// Datos de los modelos
const models = {
  basic: {
    name: "Infinity Smartwatch Básico",
    description: "",
    price: "$199",
    image: "images/smartwatch-basic.webp",
  },
  premium: {
    name: "Infinity Smartwatch Premium",
    description: "",
    price: "$299",
    image: "images/smartwatch-premium.webp",
  },
  pro: {
    name: "Infinity Smartwatch Pro",
    description: "",
    price: "$399",
    image: "images/smartwatch-pro.webp",
  },
  elite: {
    name: "Infinity Smartwatch Elite",
    description: "",
    price: "$499",
    image: "images/smartwatch-elite.webp",
  },
  ultimate: {
    name: "Infinity Smartwatch Ultimate",
    description: "",
    price: "$599",
    image: "images/smartwatch-ultimate.webp",
  },
};

// Obtener el modelo de la URL
const urlParams = new URLSearchParams(window.location.search);
const model = urlParams.get("model");

// Manejar contenido dinámico
if (models[model]) {
  document.getElementById("model-title").textContent = models[model].name;
  document.getElementById("model-name").textContent = models[model].name;
  document.getElementById("model-description").textContent = models[model].description;
  document.getElementById("model-price").textContent = models[model].price;
  document.getElementById("model-image").src = models[model].image;

  // Verificar carga de imagen
  document.getElementById("model-image").addEventListener("error", () => {
    document.getElementById("model-image").src = "images/default-placeholder.png";
    document.getElementById("model-image").alt = "Imagen no disponible";
  });
} else {
  // Si no existe el modelo
  document.querySelector(".container").innerHTML = `
    <h1 class="text-center text-danger">Modelo no encontrado</h1>
    <p class="text-center">Por favor, verifica el enlace o selecciona otro modelo.</p>
    <button class="btn btn-back mt-3" onclick="window.history.back();">&larr; Volver</button>`;
}

// Función para el botón "Volver"
document.getElementById("btn-back").addEventListener("click", () => {
  if (window.history.length > 1) {
    window.history.back(); // Regresa a la página anterior
  } else {
    window.location.href = "index.html"; // Redirige al inicio si no hay historial
  }
});
